const ADODB = require('node-adodb');
var fits = require('./lib-fits');

var GCNT = fits.ini.GCNT;
if (GCNT == undefined) {
    GCNT = "Provider=SQLOLEDB.1;Persist Security Info=False;User ID=IDSA;Initial Catalog=BKSQL;Data Source=(LOCAL);password=1111";
}

var connection = ADODB.open(GCNT);
connectTest();


module.exports = {
    schema() {
        return connection.schema(20, ["BKSQL", "dbo", , "TABLE"]);
    },
    schema4() { //不是每個欄位都抓的到
        return connection.schema(4, ["BKSQL", "dbo", "MENUITEM", "ItemName"]);
    },
    query(sql) {
        return connection.query(sql);
    },
    exec(sql) {
        return connection.execute(sql, 'SELECT @@Identity AS id')
    },
    async getInvoice(invno) {
        try {
            var sql = "select * from invoice where InvNo = " + fits.quot(invno);
            var data = await connection.query(sql);
            if (data.length == 0) { return ""; }
            return data[0];
        } catch (error) {
            fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString(), SQL: sql });
        }
    },
    async getCheckNo(invno) {
        try {
            var sql = "select * from invoice where InvNo = " + fits.quot(invno);
            var data = await connection.query(sql);
            if (data.length == 0) { return ""; }
            return data[0].CheckNo;
        } catch (error) {
            fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString(), SQL: sql });
        }
    },
    async getParam(paramid) {
        try {
            var sql = "select * from xxparam where paramid = " + fits.quot(paramid);
            var data = await connection.query(sql);
            if (data.length == 0) { return ""; }
            return data[0].ParamValue;
        } catch (error) {
            fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString(), SQL: sql });
        }
    },

    xxparam() {
        var sql = 'SELECT * FROM xxParam ';
        return connection.query(sql);
    },

    menutype() {
        var sql = 'SELECT * FROM MenuType Order By TypeNo , ItemNo ';
        return connection.query(sql);
    },
    xxcode() {
        var sql = 'SELECT * FROM MenuType Order By TypeNo , ItemNo ';
        return connection.query(sql);
    },

};


async function connectTest() {
    try {
        var sql = 'SELECT 1 as a ';
        await connection.query(sql);
        fits.writeLog("DB Connection OK");
    } catch (error) {
        fits.writeLog("DB Connection Error:" + error, GCNT);
    }
}