var fs = require("fs");
const fsp = fs.promises;
var middle = require('./basic-middle.js');
var InvE = require('./class-InvE.js');
var api = require('./api-Tradeven');
var parse = require('./parse-tradeven');
var bk35 = require('./lib-adodb.js');
var moment = require("moment");
var fits = require('./lib-fits');
const path = require("path")

var timer1 = null;
var timer2 = null;

main();

async function main() {

    var file = await middle.getFiles();
    let dir = await middle.getDir();


    let listDir2024 = path.join(dir.path, "InvNOBEList", "202404"); //大宅門切換期別把所有發票批次號都取光了
    await fits.mkdir(listDir2024);




    timer1_start(file);

    timer2_start(file);


}

function timer1_start(file) {
    timer1 = setInterval(scanInvNOBENext, 1000 * 1 * 3, file); //下載發票批次，存到第2批

    fits.writeLog("開始D1");
};

function timer1_stop() {
    timer1 = clearInterval(timer1);
    fits.writeLog("暫停D1");
};

function timer2_start(file) {
    timer2 = setInterval(scanInvNextTerm, 1000 * 1 * 3, file); //取得下期的發票號
    fits.writeLog("開始D2");
};

function timer2_stop() {
    timer2 = clearInterval(timer2);
    fits.writeLog("暫停D2");
};


async function scanInvNOBENext(file) {
    try {
        // console.log("find", file.invNOBENext)
        if (fs.existsSync(file.invNOBENext)) return;

        var ip = await fits.getSetting("BK3", "IP");
        if (fits.str(ip.QRCode) != "Tradeven") { return; }


        timer1_stop();

        var period = await getPeriod();
        fits.writeLog("取號期別:", period);

        let used = await useInvPatchFile(file, period); // 使用備援文字檔，沒有文字檔時->走正常api取號

        if (used == false) {
            var body = await parse.invTerm(period);
            fits.writeLog("送出的資料", JSON.stringify(body));

            var res = await api.next_term(body);
            fits.writeLog("收到的資料", JSON.stringify(res));

            if (res.message == "Success") {
                if (res.resultdata[0].success == "Y") {
                    var term = new InvE.InvTerm(res);
                    var line = term.invnob + ",";
                    line += term.invnoe + ",";
                    line += term.event_id + ",";
                    line += term.year + ",";
                    line += term.month;

                    await middle.writeIinvNOBENext(line);
                    fits.writeLog("寫入發票批次檔invNOBENext", line);
                }
            }
        }

        timer1_start(file);


    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }

}




async function scanInvNextTerm(file) {

    try {

        var ip = await fits.getSetting("BK3", "IP");
        if (fits.str(ip.QRCode) != "Tradeven") { return; }


        if (fs.existsSync(file.invNextTerm)) {
            return;
        }

        if (!await isExpiring()) { // 雙月份大於22號(依營業日)
            return;
        }



        timer2_stop();

        var period = await getPeriodNext();
        fits.writeLog("取號期別:", period);

        var body = await parse.invTerm(period);
        fits.writeLog("送出的資料", JSON.stringify(body));

        var res = await api.next_term(body);
        fits.writeLog("收到的資料", JSON.stringify(res));

        if (res.message == "Success") {
            if (res.resultdata[0].success == "Y") {
                var term = new InvE.InvTerm(res);
                var line = term.invnob + ",";
                line += term.invnoe + ",";
                line += term.event_id + ",";
                line += term.year + ",";
                line += term.month;

                await middle.writeInvNextTerm(line);
                fits.writeLog("寫入發票批次檔invNextTerm", line);
            }
        }

        timer2_start(file);

    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }
}







async function getPeriod() {
    try {

        var opdate = await bk35.getParam("opdate");
        var year = opdate.substring(0, 4).toString();
        var month = fits.val(opdate.substring(5, 7).toString());

        if (month <= 2) {
            return year + "02";
        } else if (month <= 4) {
            return year + "04";
        } else if (month <= 6) {
            return year + "06";
        } else if (month <= 8) {
            return year + "08";
        } else if (month <= 10) {
            return year + "10";
        } else if (month <= 12) {
            return year + "12";
        }
        return ""

    } catch (error) {

        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }
}

async function getPeriodNext() {
    try {

        var opdate = await bk35.getParam("opdate");
        var year = opdate.substring(0, 4).toString();
        var month = Number(opdate.substring(5, 7).toString());

        if (month <= 2) {
            return year + "04";
        } else if (month <= 4) {
            return year + "06";
        } else if (month <= 6) {
            return year + "08";
        } else if (month <= 8) {
            return year + "10";
        } else if (month <= 10) {
            return year + "12";
        } else if (month <= 12) {
            return Number(year) + 1 + "02";
        }
        return ""

    } catch (error) {

        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }
}


async function isExpiring() { // 該取下一期了
    try {
        // var month = moment().month();
        // var day = Number(moment().format("D"));

        var opdate = await bk35.getParam("opdate");
        // var year = opdate.substring(0, 4).toString();
        var month = fits.val(opdate.substring(5, 7).toString());
        var day = fits.val(opdate.substring(8, 10).toString());
        if (day >= 22) {
            if (month % 2 == 0) {
                console.log("month", month, "day", day);
                return true;
            }
        }
        return false;
    } catch (error) {
        fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString() });
    }
}




async function useInvPatchFile(file, pPeriod) { //備援使用
    try {
        let list = [];

        var inveDir = await fits.getSetting("BK3", "IP", "InvE_Dir");
        inveDir = fits.str(inveDir);
        let dir = path.join(inveDir, "InvNOBEList", pPeriod);
        try {
            list = await fsp.readdir(dir);
        } catch (error) {}

        if (list.length == 0) return false;
        list = list.sort();
        let invFile = path.join(dir, list[0]);
        await fsp.rename(invFile, file.invNOBENext);
        fits.writeLog("使用發票批次檔案(rename):", invFile, file.invNOBENext);
        return true;
    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
        return false;
    }

}